//
//  BIStatementLineItem.h
//  BISubstrate
//
//  Created by Fraser Kuyvenhoven on 26/06/08.
//  Copyright 2008 Marketcircle. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIInvoice;
@class BIPayment;
@class BIRetainer;

@interface BIStatementLineItem : NSObject
{
	NSCalendarDate *date;
	NSString *type;
	NSArray *invoices; // containing keys "invoiceNumber" and "amountApplied"
	NSString *method;
	NSNumber *amount;
	NSNumber *invoiceBalance;
	NSNumber *accountBalance;
	
	BIPayment *payment;
	BIInvoice *invoice;
    BIRetainer *retainer;
}

+ (BIStatementLineItem *)statementLineItemForInvoice:(BIInvoice *)anInvoice;
+ (BIStatementLineItem *)statementLineItemForPayment:(BIPayment *)aPayment;
+ (BIStatementLineItem *)statementLineItemForRetainer:(BIRetainer *)aRetainer;

@property (retain) BIRetainer *retainer;

- (NSCalendarDate*)date;
- (void)setDate:(NSCalendarDate*)inDate;

- (NSString*)type;
- (void)setType:(NSString*)inType;

// array of BIStatementLineItemInvoice
- (NSArray*)invoices;
- (void)setInvoices:(NSArray*)inInvoices;

- (BIInvoice *)invoice;
- (void)setInvoice:(BIInvoice *)anInvoice;

- (BIPayment *)payment;
- (void)setPayment:(BIPayment *)aPayment;

- (NSString*)method;
- (void)setMethod:(NSString*)inMethod;

- (NSNumber*)amount;
- (void)setAmount:(NSNumber*)inAmount;

- (NSNumber*)invoiceBalance;
- (void)setInvoiceBalance:(NSNumber*)inBalance;

- (NSNumber*)accountBalance;
- (void)setAccountBalance:(NSNumber*)inBalance;

- (NSString *)invoiceNumbersCommaSeparated;
- (NSString *)invoiceNumbersNewlineSeparated;

- (NSString *)invoiceProjectNamesNewlineSeparated;
- (NSString *)invoiceProjectNamesCommaSeparated;

@end
